/*
 * Decompiled with CFR 0.152.
 */
package AGR;

import AGR.Edge;
import AGR.Graph;
import AGR.MainWindow;
import AGR.Vertex;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JPanel;

public class GraphView
extends JPanel
implements MouseMotionListener,
MouseListener {
    private Graph m_graph;
    final int NODE_DIM_HEIGHT = 30;
    final int NODE_DIM_WIDTH = 80;
    Vertex m_lastVertexClicked;
    Vertex m_lastVertexOver;
    Point m_lastMousePos = new Point();
    Point m_mouseOffsetInVertex = new Point();
    Edge m_lastEdgeOver;
    public boolean m_doRelax;
    int no = 0;

    public GraphView() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void setGraph(Graph gr) {
        this.m_graph = gr;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        if (GraphView.this.m_doRelax) {
                            1.sleep(10L);
                        } else {
                            1.sleep(250L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (GraphView.this.m_doRelax) {
                            GraphView.this.m_graph.relaxVerticePositions();
                            GraphView.this.repaint();
                        }
                    }
                }
            }
        }.start();
    }

    public void paint(Graphics g) {
        Vertex nd;
        Iterator it;
        Dimension dim = this.getSize();
        g.setColor(Color.CYAN);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(Color.BLACK);
        boolean cnt = false;
        Hashtable<Vertex, Integer> edgeCount = new Hashtable<Vertex, Integer>();
        this.m_lastEdgeOver = null;
        if (this.m_graph != null) {
            it = this.m_graph.vertices.iterator();
            while (it.hasNext()) {
                nd = (Vertex)it.next();
                if (nd.edges == null) continue;
                edgeCount.clear();
                for (int e = 0; e < nd.edges.length; ++e) {
                    Vertex n2 = null;
                    Edge currentEdge = this.m_graph.findEdge(nd.edges[e]);
                    int count = currentEdge.to;
                    n2 = this.m_graph.findVertex(count);
                    if (n2 == null) {
                        throw new Error("Vertex have assigned null edge");
                    }
                    if (edgeCount.containsKey(n2)) {
                        Integer intg = (Integer)edgeCount.get(n2);
                        edgeCount.put(n2, new Integer(intg + 1));
                    } else {
                        edgeCount.put(n2, new Integer(1));
                    }
                    int targetVertexCount = 0;
                    targetVertexCount = (Integer)edgeCount.get(n2) - 1;
                    if (nd.getX() == n2.getX() && nd.getY() == n2.getY()) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setColor(currentEdge.color);
                        g.drawArc((int)nd.getX() - 8, (int)nd.getY() - 8, 16, 16, 70, 270);
                        this.drawArrow((Graphics2D)g, nd.getX() + 4.0f, nd.getY() - 8.0f, nd.getX() + 8.0f, nd.getY(), 6.0f, 5.0f);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        Rectangle2D.Float edgeRect = new Rectangle2D.Float(nd.getX() - 16.0f, nd.getY() - 16.0f, 15.0f, 15.0f);
                        if (this.m_lastMousePos != null && edgeRect.contains(this.m_lastMousePos)) {
                            this.m_lastEdgeOver = currentEdge;
                        }
                        if (this.m_lastEdgeOver == currentEdge) {
                            g.setColor(Color.BLUE);
                            g.fillRect((int)edgeRect.getMinX(), (int)edgeRect.getMinY(), 15, 15);
                            g.setColor(Color.yellow);
                        } else {
                            g.setColor(Color.black);
                        }
                        g.drawString("" + currentEdge.value, (int)edgeRect.getMinX(), (int)edgeRect.getMinY() + 12);
                        g.setColor(Color.black);
                        continue;
                    }
                    Rectangle rect = new Rectangle((int)n2.getX(), (int)n2.getY(), 80, 30);
                    Rectangle rect2 = new Rectangle((int)nd.getX(), (int)nd.getY(), 80, 30);
                    Line2D.Float line = new Line2D.Float(nd.getX() + 15.0f, nd.getY() + 15.0f, n2.getX() + 15.0f + (float)Math.min(targetVertexCount * 8, 79), n2.getY() + 15.0f + (float)Math.min(targetVertexCount * 8, 29));
                    if (0 != targetVertexCount) {
                        System.out.println("" + targetVertexCount);
                    }
                    Point2D.Float pt = this.lineRectIntersection(rect, line);
                    Point2D.Float pt2 = this.lineRectIntersection(rect2, line);
                    if (pt == null || pt2 == null) continue;
                    g.setColor(currentEdge.color);
                    this.drawArrow((Graphics2D)g, pt2.x, pt2.y, pt.x, pt.y, 6.0f, 5.0f);
                    Point2D.Float pnt = new Point2D.Float();
                    Point2D.Float pnt2 = new Point2D.Float();
                    Point2D.Float drawPnt = new Point2D.Float();
                    ((Point2D)pnt).setLocation(pt2.x - pt.x, pt2.y - pt.y);
                    float mag = (float)Math.sqrt(((Point2D)pnt).getX() * ((Point2D)pnt).getX() + ((Point2D)pnt).getY() * ((Point2D)pnt).getY());
                    ((Point2D)pnt).setLocation(((Point2D)pnt).getX() / (double)mag, ((Point2D)pnt).getY() / (double)mag);
                    ((Point2D)pnt2).setLocation(((Point2D)pnt).getY(), -((Point2D)pnt).getX());
                    ((Point2D)drawPnt).setLocation((double)pt.x + 10.0 * ((Point2D)pnt).getX() + 5.0 * ((Point2D)pnt2).getX(), (double)(5.0f + pt.y) + 10.0 * ((Point2D)pnt).getY() + 5.0 * ((Point2D)pnt2).getX());
                    Rectangle2D.Float edgeRect = new Rectangle2D.Float((float)((Point2D)drawPnt).getX() - 2.0f, (float)((Point2D)drawPnt).getY() - 14.0f, 15.0f, 15.0f);
                    if (this.m_lastMousePos != null && edgeRect.contains(this.m_lastMousePos)) {
                        this.m_lastEdgeOver = currentEdge;
                    }
                    if (this.m_lastEdgeOver == currentEdge) {
                        g.setColor(Color.BLUE);
                        g.fillRect((int)edgeRect.getMinX(), (int)edgeRect.getMinY(), 15, 15);
                        g.setColor(Color.yellow);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawString("" + currentEdge.value, (int)((Point2D)drawPnt).getX(), (int)((Point2D)drawPnt).getY() - 1);
                    g.setColor(Color.black);
                }
            }
        }
        if (this.m_graph != null) {
            it = this.m_graph.vertices.iterator();
            while (it.hasNext()) {
                nd = (Vertex)it.next();
                if (nd == this.m_lastVertexOver) {
                    g.setColor(Color.WHITE);
                } else if (nd == this.m_lastVertexClicked) {
                    g.setColor(Color.LIGHT_GRAY);
                } else {
                    g.setColor(nd.getCol());
                }
                g.fillRect((int)nd.getX(), (int)nd.getY(), 80, 30);
                g.setColor(Color.BLACK);
                g.drawRect((int)nd.getX(), (int)nd.getY(), 80, 30);
                g.drawString(nd.toString(), (int)nd.getX() + 1, (int)nd.getY() + 11);
                g.drawString(nd.getVarsAsString(), (int)nd.getX() + 1, (int)nd.getY() + 22);
            }
        }
    }

    public static void main(String[] args) {
    }

    public Point2D.Float lineRectIntersection(Rectangle rect, Line2D.Float line) {
        if (!rect.intersects(rect)) {
            return null;
        }
        Line2D.Float[] rlines = new Line2D.Float[]{new Line2D.Float(rect.x, rect.y, rect.x + rect.width, rect.y), new Line2D.Float(rect.x, rect.y, rect.x, rect.y + rect.height), new Line2D.Float(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height), new Line2D.Float(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height)};
        Point2D.Float minp = null;
        Point2D.Float tmpp = null;
        float dist = 9999.0f;
        for (int i = 0; i < 4; ++i) {
            float d;
            tmpp = this.lineInt(rlines[i], line);
            if (tmpp == null || !((d = (float)line.getP1().distance(tmpp)) < dist)) continue;
            dist = d;
            minp = tmpp;
        }
        return minp;
    }

    public Point2D.Float lineInt(Line2D.Float a, Line2D.Float b) {
        Point2D.Float diff1 = new Point2D.Float(b.x1 - a.x1, b.y1 - a.y1);
        Point2D.Float diff2 = new Point2D.Float(a.x1 - b.x1, a.y1 - b.y1);
        Point2D.Float d1 = new Point2D.Float(a.x2 - a.x1, a.y2 - a.y1);
        Point2D.Float d2 = new Point2D.Float(b.x2 - b.x1, b.y2 - b.y1);
        Point2D.Float td1 = new Point2D.Float(d1.y, -d1.x);
        Point2D.Float td2 = new Point2D.Float(d2.y, -d2.x);
        float s = (diff1.x * td2.x + diff1.y * td2.y) / (d1.x * td2.x + d1.y * td2.y);
        float t = (diff2.x * td1.x + diff2.y * td1.y) / (d2.x * td1.x + d2.y * td1.y);
        if (s < 0.0f || s > 1.0f) {
            return null;
        }
        if (t < 0.0f || t > 1.0f) {
            return null;
        }
        Point2D.Float res = new Point2D.Float(a.x1 + d1.x * s, a.y1 + d1.y * s);
        return res;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.m_lastVertexOver != null) {
            this.m_lastVertexOver.setX(e.getPoint().x - this.m_mouseOffsetInVertex.x);
            this.m_lastVertexOver.setY(e.getPoint().y - this.m_mouseOffsetInVertex.y);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.m_graph == null) {
            return;
        }
        this.m_lastMousePos.x = e.getPoint().x;
        this.m_lastMousePos.y = e.getPoint().y;
        Collection col = this.m_graph.getVerticies();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Vertex vert = (Vertex)it.next();
            if (!((float)e.getPoint().x >= vert.getX()) || !((float)e.getPoint().x <= vert.getX() + 80.0f) || !((float)e.getPoint().y >= vert.getY()) || !((float)e.getPoint().y <= vert.getY() + 30.0f)) continue;
            this.m_lastVertexOver = vert;
            this.repaint();
            return;
        }
        if (this.m_lastVertexOver != null) {
            this.m_lastVertexOver = null;
            this.repaint();
        }
    }

    public Vertex getLastVertexOver() {
        return this.m_lastVertexOver;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && this.m_lastVertexOver != null) {
            MainWindow.printToConsole("\n" + this.m_lastVertexOver);
            String str = "";
            if (this.m_lastVertexOver.edges != null) {
                str = " nodes : ";
                for (int i = 0; i < this.m_lastVertexOver.edges.length; ++i) {
                    str = str + this.m_graph.findEdge((int)this.m_lastVertexOver.edges[i]).to + ",";
                }
            }
            MainWindow.printToConsole(str);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.m_lastVertexClicked = this.m_lastVertexOver;
        if (this.m_lastVertexOver != null) {
            this.m_mouseOffsetInVertex.x = e.getPoint().x - (int)this.m_lastVertexClicked.getX();
            this.m_mouseOffsetInVertex.y = e.getPoint().y - (int)this.m_lastVertexClicked.getY();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.m_lastVertexClicked = this.m_lastVertexOver;
    }

    void drawArrow(Graphics2D g, float x1, float y1, float x2, float y2, float al, float aw) {
        Point2D.Float start = new Point2D.Float(x1, y1);
        Point2D.Float end = new Point2D.Float(x2, y2);
        Point2D.Float base = new Point2D.Float();
        Point2D.Float back_top = new Point2D.Float();
        Point2D.Float back_bottom = new Point2D.Float();
        float length = (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        float x = (x2 - x1) / length;
        float y = (y2 - y1) / length;
        ((Point2D)base).setLocation(x2 - x * al, y2 - y * al);
        ((Point2D)back_top).setLocation(((Point2D)base).getX() - (double)(aw * y), ((Point2D)base).getY() + (double)(aw * x));
        ((Point2D)back_bottom).setLocation(((Point2D)base).getX() + (double)(aw * y), ((Point2D)base).getY() - (double)(aw * x));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.draw(new Line2D.Float(start, end));
        g.fillPolygon(new int[]{(int)(((Point2D)back_bottom).getX() + 0.5), (int)(((Point2D)end).getX() + 0.5), (int)(((Point2D)back_top).getX() + 0.5)}, new int[]{(int)(((Point2D)back_bottom).getY() + 0.5), (int)(((Point2D)end).getY() + 0.5), (int)(((Point2D)back_top).getY() + 0.5)}, 3);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

