/*
 * Decompiled with CFR 0.152.
 */
package AGR;

import AGR.AppletWindow;
import AGR.Edge;
import AGR.Graph;
import AGR.GraphView;
import AGR.Plugin;
import AGR.Vertex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class MainWindow
extends JFrame
implements ActionListener,
MouseListener,
ChangeListener {
    public Graph m_graph;
    public GraphView m_graphView;
    JButton m_loadBtn;
    JButton m_saveBtn;
    JButton m_relaxBtn;
    JButton m_newGraph;
    JButton m_stepRewind = new JButton("Init");
    JButton m_stepToEnd = new JButton("End");
    JButton m_stepForward = new JButton(">>");
    JButton m_stepBackward = new JButton("<<");
    JButton m_stepPause = new JButton("||");
    boolean m_wasPausePressed = false;
    JButton m_stepPlay = new JButton(">");
    Vector m_plugins = new Vector();
    JList m_pluginList;
    static JTextPane m_tp;
    JCheckBox m_diGraph;
    Vertex m_lastPressedVertex;
    JRadioButton m_ownFormatRadioBtn;
    JRadioButton m_objFormatRadioBtn;
    ButtonGroup m_radioGrp;
    JRadioButton m_addVertexRadioBtn;
    JRadioButton m_addEdgeRadioBtn;
    JRadioButton m_moveNodeBtn;
    JRadioButton m_removeNodeBtn;
    JRadioButton m_removeEdgeBtn;
    JRadioButton m_changeEdgeValueBtn;
    JRadioButton m_changeNodeValueBtn;
    ButtonGroup m_operRadioGrp;
    JSlider m_slider;

    public MainWindow() {
        this.setTitle("Graph viz 1.0");
        this.lookForPlugins();
        this.setBounds(100, 100, 640, 480);
        if (!AppletWindow.m_appletMode) {
            this.setDefaultCloseOperation(3);
        }
        this.getContentPane().setLayout(new BorderLayout());
        Box mainScreenBox = Box.createVerticalBox();
        Box upperBarBox = Box.createHorizontalBox();
        Box leftBarBox = Box.createVerticalBox();
        this.m_graphView = new GraphView();
        this.m_graph = new Graph();
        this.m_graphView.setGraph(this.m_graph);
        this.m_graphView.setPreferredSize(new Dimension(640, 300));
        m_tp = new JTextPane();
        m_tp.setFont(Font.getFont("fixedsys"));
        JScrollPane sp = new JScrollPane(m_tp);
        m_tp.setEditable(false);
        sp.setPreferredSize(new Dimension(640, 120));
        m_tp.setPreferredSize(new Dimension(640, 120));
        mainScreenBox.add(new JScrollPane(this.m_graphView));
        JSplitPane splitPane = new JSplitPane(0, new JScrollPane(this.m_graphView), sp);
        this.getContentPane().add((Component)splitPane, "Center");
        if (AppletWindow.ms_applet == null) {
            this.m_loadBtn = new JButton("load");
            upperBarBox.add(this.m_loadBtn);
            this.m_saveBtn = new JButton("save");
            upperBarBox.add(this.m_saveBtn);
        }
        this.m_newGraph = new JButton("new graph");
        upperBarBox.add(this.m_newGraph);
        this.m_radioGrp = new ButtonGroup();
        if (!AppletWindow.m_appletMode) {
            this.m_ownFormatRadioBtn = new JRadioButton("gd0 format");
            this.m_radioGrp.add(this.m_ownFormatRadioBtn);
            this.m_objFormatRadioBtn = new JRadioButton("obj format");
            this.m_radioGrp.add(this.m_objFormatRadioBtn);
            leftBarBox.add(this.m_ownFormatRadioBtn);
            leftBarBox.add(this.m_objFormatRadioBtn);
        }
        this.m_relaxBtn = new JButton("relax");
        leftBarBox.add(this.m_relaxBtn);
        this.m_slider = new JSlider(0, 500);
        leftBarBox.add(this.m_slider);
        this.m_slider.setPreferredSize(new Dimension(35, 20));
        this.m_slider.addChangeListener(this);
        this.m_diGraph = new JCheckBox("digraph", true);
        leftBarBox.add(this.m_diGraph);
        this.m_operRadioGrp = new ButtonGroup();
        this.m_addVertexRadioBtn = new JRadioButton("add node");
        this.m_operRadioGrp.add(this.m_addVertexRadioBtn);
        this.m_addEdgeRadioBtn = new JRadioButton("add edge");
        this.m_operRadioGrp.add(this.m_addEdgeRadioBtn);
        this.m_moveNodeBtn = new JRadioButton("move node");
        this.m_operRadioGrp.add(this.m_moveNodeBtn);
        this.m_removeEdgeBtn = new JRadioButton("remove edge");
        this.m_operRadioGrp.add(this.m_removeEdgeBtn);
        this.m_removeNodeBtn = new JRadioButton("remove node");
        this.m_operRadioGrp.add(this.m_removeNodeBtn);
        this.m_changeEdgeValueBtn = new JRadioButton("<HTML>change edge<br> value");
        this.m_operRadioGrp.add(this.m_changeEdgeValueBtn);
        this.m_changeNodeValueBtn = new JRadioButton("<HTML>change node<br> variables");
        this.m_operRadioGrp.add(this.m_changeNodeValueBtn);
        this.m_operRadioGrp.setSelected(this.m_addVertexRadioBtn.getModel(), true);
        leftBarBox.add(this.m_addVertexRadioBtn);
        leftBarBox.add(this.m_addEdgeRadioBtn);
        leftBarBox.add(this.m_moveNodeBtn);
        leftBarBox.add(this.m_removeNodeBtn);
        leftBarBox.add(this.m_removeEdgeBtn);
        leftBarBox.add(this.m_changeEdgeValueBtn);
        leftBarBox.add(this.m_changeNodeValueBtn);
        JScrollPane scrollp = new JScrollPane();
        scrollp.setPreferredSize(new Dimension(20, 100));
        scrollp.getViewport().setView(this.m_pluginList);
        leftBarBox.add(new JLabel("loaded plugins:"));
        leftBarBox.add(scrollp);
        upperBarBox.add(this.m_stepRewind);
        upperBarBox.add(this.m_stepBackward);
        upperBarBox.add(this.m_stepPause);
        upperBarBox.add(this.m_stepPlay);
        upperBarBox.add(this.m_stepForward);
        this.getContentPane().add((Component)upperBarBox, "North");
        this.getContentPane().add((Component)leftBarBox, "West");
        this.m_newGraph.addActionListener(this);
        if (!AppletWindow.m_appletMode) {
            this.m_radioGrp.setSelected(this.m_ownFormatRadioBtn.getModel(), true);
            this.m_loadBtn.addActionListener(this);
            this.m_saveBtn.addActionListener(this);
        }
        this.m_relaxBtn.addActionListener(this);
        this.m_stepRewind.addActionListener(this);
        this.m_stepToEnd.addActionListener(this);
        this.m_stepForward.addActionListener(this);
        this.m_stepBackward.addActionListener(this);
        this.m_stepPause.addActionListener(this);
        this.m_stepPlay.addActionListener(this);
        this.pack();
        this.m_graphView.setPreferredSize(new Dimension(2000, 2000));
        splitPane.setDividerLocation(0.8);
        splitPane.setOneTouchExpandable(true);
        this.m_graphView.addMouseListener(this);
        MainWindow.printToConsole("Graph viz 1.0 by Marcin J\u0119drzejewski\n");
        MainWindow.printToConsole("email: s1525@pjwstk.edu.pl\n");
        MainWindow.printToConsole("  www: http://www.pjwstk.edu.pl/~s1525\n");
    }

    protected static String ask4file(final String ext) throws IOException {
        JFileChooser fc = new JFileChooser();
        String uname = "";
        if (uname == null) {
            uname = "";
        }
        fc.setSelectedFile(new File(uname));
        fc.setCurrentDirectory(new File("."));
        fc.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Graph files";
            }

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(ext);
            }
        });
        int returnVal = fc.showDialog(null, "Ok");
        File file = null;
        if (returnVal == 0) {
            file = fc.getSelectedFile();
            if (!file.getName().endsWith(ext)) {
                file = new File(file.getAbsolutePath() + ext);
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
        if (file == null) {
            return "";
        }
        return file.getCanonicalPath();
    }

    public static void main(String[] args) {
        new MainWindow().show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Object plugin;
        JButton err2;
        if (e.getSource() == this.m_loadBtn) {
            try {
                String fname;
                if (this.m_ownFormatRadioBtn.isSelected()) {
                    fname = MainWindow.ask4file(".gd0");
                    if (fname.length() > 0) {
                        this.m_graph = new Graph();
                    }
                    this.m_graph.loadFromGD0(fname);
                }
                if (this.m_objFormatRadioBtn.isSelected()) {
                    fname = MainWindow.ask4file(".obj");
                    if (fname.length() > 0) {
                        this.m_graph = new Graph();
                    }
                    this.m_graph = Graph.loadObj(fname);
                }
            }
            catch (IOException err2) {
                err2.printStackTrace();
            }
            this.m_graphView.setGraph(this.m_graph);
            this.m_graphView.repaint();
        }
        if (e.getSource() == this.m_newGraph) {
            Vertex.nextFreeId = 0;
            this.m_graph = new Graph();
            this.m_graphView.setGraph(this.m_graph);
            this.m_graphView.repaint();
        }
        if (e.getSource() == this.m_stepPause) {
            err2 = this.m_stepPlay;
            synchronized (err2) {
                this.m_wasPausePressed = true;
            }
            this.m_graphView.repaint();
        }
        if (e.getSource() == this.m_stepForward) {
            if (this.m_graph == null || this.m_pluginList.getSelectedIndex() == -1) {
                return;
            }
            err2 = this.m_stepPlay;
            synchronized (err2) {
                this.m_wasPausePressed = true;
            }
            plugin = (Plugin)this.m_plugins.elementAt(this.m_pluginList.getSelectedIndex());
            if (!plugin.canDoForward()) {
                return;
            }
            if (plugin.isFinished()) {
                plugin.start(this.m_graph, this.m_graphView.m_lastVertexClicked);
            }
            plugin.incStep();
            this.m_graphView.repaint();
        }
        if (e.getSource() == this.m_stepBackward) {
            if (this.m_graph == null || this.m_pluginList.getSelectedIndex() == -1) {
                return;
            }
            plugin = this.m_stepPlay;
            synchronized (plugin) {
                this.m_wasPausePressed = true;
            }
            plugin = (Plugin)this.m_plugins.elementAt(this.m_pluginList.getSelectedIndex());
            if (!plugin.canDoBackward()) {
                return;
            }
            if (plugin.isFinished()) {
                plugin.start(this.m_graph, this.m_graphView.m_lastVertexClicked);
            }
            plugin.decStep();
            this.m_graphView.repaint();
        }
        if (e.getSource() == this.m_stepPlay && this.m_graph != null && this.m_pluginList.getSelectedIndex() != -1) {
            plugin = (Plugin)this.m_plugins.elementAt(this.m_pluginList.getSelectedIndex());
            if (plugin.isFinished()) {
                plugin.start(this.m_graph, this.m_graphView.m_lastVertexClicked);
            }
            this.m_graphView.repaint();
            if (!plugin.isFinished()) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        JButton jButton = MainWindow.this.m_stepPlay;
                        synchronized (jButton) {
                            MainWindow.this.m_wasPausePressed = false;
                        }
                        this.setName("Play thread");
                        Plugin plugin = (Plugin)MainWindow.this.m_plugins.elementAt(MainWindow.this.m_pluginList.getSelectedIndex());
                        while (true) {
                            JButton jButton2 = MainWindow.this.m_stepPlay;
                            synchronized (jButton2) {
                                if (MainWindow.this.m_wasPausePressed) {
                                    MainWindow.this.m_wasPausePressed = false;
                                    return;
                                }
                            }
                            if (plugin.isFinished()) {
                                MainWindow.this.m_graphView.repaint();
                                return;
                            }
                            plugin.incStep();
                            MainWindow.this.m_graphView.repaint();
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                }.start();
            }
        }
        if (e.getSource() == this.m_stepRewind && this.m_graph != null && this.m_pluginList.getSelectedIndex() != -1) {
            plugin = (Plugin)this.m_plugins.elementAt(this.m_pluginList.getSelectedIndex());
            plugin.setStartStep();
            this.m_graphView.repaint();
        }
        if (e.getSource() == this.m_saveBtn) {
            try {
                if (this.m_ownFormatRadioBtn.isSelected()) {
                    this.m_graph.saveAsGD0(MainWindow.ask4file(".gd0"));
                }
                if (this.m_objFormatRadioBtn.isSelected()) {
                    this.m_graph.save(MainWindow.ask4file(".obj"));
                }
            }
            catch (IOException err3) {
                err3.printStackTrace();
            }
            this.m_graphView.setGraph(this.m_graph);
        }
        if (e.getSource() == this.m_relaxBtn) {
            GraphView graphView = this.m_graphView;
            synchronized (graphView) {
                this.m_graphView.m_doRelax = !this.m_graphView.m_doRelax;
            }
        }
    }

    public static void printToConsole(String str) {
        Document doc = m_tp.getDocument();
        try {
            doc.insertString(doc.getEndPosition().getOffset() - 1, str, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        m_tp.getCaret().setDot(doc.getEndPosition().getOffset() - 1);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        String newValue;
        Serializable vert;
        if (e.getButton() != 1) {
            return;
        }
        if (this.m_operRadioGrp.getSelection() == this.m_addVertexRadioBtn.getModel()) {
            vert = new Vertex();
            vert.setX(e.getPoint().x);
            vert.setY(e.getPoint().y);
            vert.setVertexHashVars("k=0");
            if (this.m_graph != null) {
                this.m_graph.addVertex((Vertex)vert);
            }
        }
        if (this.m_operRadioGrp.getSelection() == this.m_removeNodeBtn.getModel() && this.m_graph != null && this.m_graphView.m_lastVertexOver != null) {
            vert = this.m_graphView;
            synchronized (vert) {
                this.m_graph.removeVertex(this.m_graphView.m_lastVertexOver);
            }
        }
        if (this.m_operRadioGrp.getSelection() == this.m_removeEdgeBtn.getModel() && this.m_graph != null && this.m_graphView.m_lastEdgeOver != null) {
            vert = this.m_graphView;
            synchronized (vert) {
                this.m_graph.removeEdge(this.m_graphView.m_lastEdgeOver);
            }
        }
        if (this.m_operRadioGrp.getSelection() == this.m_changeEdgeValueBtn.getModel() && this.m_graph != null && this.m_graphView.m_lastEdgeOver != null) {
            vert = this.m_graphView;
            synchronized (vert) {
                newValue = JOptionPane.showInputDialog(this.getContentPane(), (Object)"new edge value");
                try {
                    this.m_graphView.m_lastEdgeOver.value = Integer.parseInt(newValue);
                }
                catch (NumberFormatException er) {
                    MainWindow.printToConsole("\nWrong number entered");
                }
            }
        }
        if (this.m_operRadioGrp.getSelection() == this.m_changeNodeValueBtn.getModel() && this.m_graph != null && this.m_graphView.m_lastVertexOver != null) {
            vert = this.m_graphView;
            synchronized (vert) {
                newValue = "";
                while ((newValue = JOptionPane.showInputDialog(this.getContentPane(), "Node value", this.m_graphView.m_lastVertexOver.getVarsAsString())) != null) {
                    if (this.hasVertexCorrectVars(newValue)) {
                        this.m_graphView.m_lastVertexOver.setVertexHashVars(newValue);
                        break;
                    }
                    JOptionPane.showMessageDialog(null, "Incorrect syntax : should be 'var1=1;var2=2'");
                }
            }
        }
        if (this.m_operRadioGrp.getSelection() == this.m_addEdgeRadioBtn.getModel() && this.m_graph != null) {
            if (this.m_lastPressedVertex == null) {
                this.m_lastPressedVertex = this.m_graphView.m_lastVertexOver;
            } else {
                if (this.m_graphView.m_lastVertexOver == null) {
                    return;
                }
                Edge edg = new Edge(this.m_lastPressedVertex.getId(), this.m_graphView.m_lastVertexOver.getId());
                int addedEdge = this.m_graph.addEdge(edg);
                this.m_lastPressedVertex.addEdge(addedEdge);
                if (!this.m_diGraph.isSelected()) {
                    edg = new Edge(this.m_graphView.m_lastVertexOver.getId(), this.m_lastPressedVertex.getId());
                    addedEdge = this.m_graph.addEdge(edg);
                    this.m_graphView.m_lastVertexOver.addEdge(addedEdge);
                }
                this.m_lastPressedVertex = null;
            }
        }
        this.m_graphView.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_slider && this.m_graph != null) {
            GraphView graphView = this.m_graphView;
            synchronized (graphView) {
                this.m_graph.MAX_LENGTH = this.m_slider.getValue();
            }
        }
    }

    public void lookForPlugins() {
        String[] pnames = null;
        if (!AppletWindow.m_appletMode) {
            File pluginDir = new File("./plugins");
            pnames = pluginDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.indexOf(".class") != -1;
                }
            });
        } else {
            pnames = new String[]{"BFS.class", "DFS.class", "ShowMatrix.class", "TransitiveClosure.class", "Transpose.class"};
        }
        for (int n = 0; n < pnames.length; ++n) {
            Class<?> newPlugin = null;
            try {
                pnames[n] = "AGR.plugins." + pnames[n].replaceAll("\\.class", "");
                newPlugin = Class.forName(pnames[n]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (newPlugin == null) continue;
            Object obj = null;
            try {
                obj = newPlugin.newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (obj == null || !(obj instanceof Plugin)) continue;
            Plugin pin = obj;
            this.m_plugins.add(pin);
        }
        this.m_pluginList = new JList(this.m_plugins);
    }

    protected boolean hasVertexCorrectVars(String nodeVars) {
        StringTokenizer stok = new StringTokenizer(nodeVars, ";");
        while (stok.hasMoreTokens()) {
            String t1 = stok.nextToken();
            StringTokenizer stok2 = new StringTokenizer(t1, "=");
            if (!stok2.hasMoreElements()) {
                return false;
            }
            t1 = stok2.nextToken();
            if (!stok2.hasMoreElements()) {
                return false;
            }
            String t2 = stok2.nextToken();
            if (!stok2.hasMoreElements()) continue;
            return false;
        }
        return true;
    }
}

