/*
 * Graph.java
 *
 * Created on 7 listopad 2003, 09:20
 */

package AGR;

import java.io.*;
import java.util.*;

/**
 *
 * @author  x
 */


public class Graph implements Serializable {
    
    float MAX_LENGTH = 200f;
    
    protected Collection vertices;
    protected Collection edges;
    
    
    public Graph() {
        vertices = new Vector();
        edges = new Vector();
    }
    
    
    public Graph(String filename) throws IOException {
        loadTxt(new File(filename));
    }
    
    
    public Graph(File file) throws IOException {
        loadTxt(file);
    }
    
    public int numberOfVerticies(){
        return vertices.size();
    }
    public Collection getVerticies(){
        return vertices;
    }
    public int addVertex(Vertex n) {
        n.setId(Vertex.getNextFreeId());
        vertices.add(n);
        return vertices.size()-1;
    }
    synchronized public void removeVertex(Vertex v) {
        if (v.edges!=null)
        {
            int cl_edges[] = (int[])v.edges.clone();
            for (int n=0; n<cl_edges.length; n++) {
                removeEdge(findEdge(cl_edges[n]));
            }
        }
        
        System.out.println("Edges 2 : " + edges.size());
        
        //usun wszystkie krawdzie od innych vertexow do tego usuwanego
        Iterator it = edges.iterator(); // dla kazdej krawedzi
        while(it.hasNext()) {
            Edge eg = (Edge)it.next();
            if (eg.to == v.id)  //jesli prowadzi do usuwanego vertexa
            {                
                Vertex vr = findVertex(eg.from);
                if(vr==null) throw new Error("Null vertex found while removing vertex");
                int newEdges[] = new int[vr.edges.length-1];
                
                for (int i=0,i2=0;i<vr.edges.length;i++)
                    if (vr.edges[i]!=eg.getId())                        
                        newEdges[i2++]=vr.edges[i];
                
                vr.edges=newEdges;
                
                it.remove();
                /*
                    Vertex vr = findVertex(n.from);
        int newEdges[] = new int[vr.edges.length-1];
        
        for (int i=0,i2=0;i<vr.edges.length;i++)
            if (vr.edges[i]!=n.getId())
                newEdges[i2++]=vr.edges[i];
        
        vr.edges=newEdges;
        edges.remove(n);
                removeEdge(eg);
                 */
            }
            
        }
        vertices.remove(v);
        repairAllVertexIds();
        System.out.println("Edges 2 : " + edges.size());
    }
    
    public void removeEdge(Edge n) {
        
        Vertex vr = findVertex(n.from);
        int newEdges[] = new int[vr.edges.length-1];
        
        for (int i=0,i2=0;i<vr.edges.length;i++)
            if (vr.edges[i]!=n.getId())
                newEdges[i2++]=vr.edges[i];
        
        vr.edges=newEdges;
        edges.remove(n);
    }
    
    public int addEdge(Edge n) {
        edges.add(n);
        return n.getId();
    }
    
    public void save(String filename) {
        if ( filename.length() == 0 ) return;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(filename);
            out = new ObjectOutputStream(fos);
            out.writeObject(this);
            out.close();
        }
        catch(IOException ex) {
            ex.printStackTrace();
        }
    }
    
    public void saveAsGD0(String filename) throws IOException {
        binOutputGraph(new FileOutputStream(new File(filename)));
        String vars_fname = filename.substring( 0,filename.lastIndexOf(".gd0"));
        saveVertexVars(new FileOutputStream(new File(vars_fname+".vrs")));
    }
            
    public void saveVertexVars(OutputStream outs) {
        if (outs == null || vertices==null) return;        
        
        PrintStream pstr = new PrintStream(outs);        
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            String vr = nd.getVarsAsString();
            if ( vr.length()==0 ) vr=";";
            pstr.print(""+nd.getId()+"\n"+vr+"\n");            
        }
    }
    
    public void loadVertexVars(InputStream ins) throws IOException {
        if (ins == null || vertices==null) return;        
        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
        String id;    
        while(true) {                       
            id = r.readLine();
            if (id==null) return;            
            int vert_id = Integer.parseInt(id);
            Vertex vert = findVertex(vert_id);            
            String vars = r.readLine();
            if (vars==null) return;
            vert.setVertexHashVars(vars);
        }       
        
    }
    
    public int[] saveGD0ToArray() throws IOException
    {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        binOutputGraph(byteStream);
        byte barr[] = byteStream.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(barr));
        int iarr[] = new int[barr.length/4];
        int pos=0;
        while(true){
            int k=0;
            try{
               k = dis.readInt();
            }
            catch(EOFException e)
            {break;}            
            iarr[pos++]=k;            
        }
        return iarr;
    }
    
    public void loadGD0FromArray(int iarr[] ) throws IOException
    {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream iStream = new DataOutputStream(byteStream);
        
        int pos=0;
        while(pos<iarr.length){           
            try{
                iStream.writeInt(iarr[pos++]);               
            }
            catch(EOFException e)
            {break;}                        
        }
        
        binLoad( new ByteArrayInputStream(byteStream.toByteArray()));
    }
    
    public static Graph loadObj(String filename) throws IOException {
        if ( filename.length() == 0 ) return null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        Graph gr=null;
        try {
            fis = new FileInputStream(filename);
            in = new ObjectInputStream(fis);
            gr = (Graph)in.readObject();
            in.close();
            Iterator it = gr.vertices.iterator();
            while(it.hasNext()){
                Vertex vert = (Vertex)it.next();
                Vertex.nextFreeId = Math.max(vert.id, Vertex.nextFreeId)+1;
            }
            it = gr.edges.iterator();
            while(it.hasNext()){
                Edge eg = (Edge)it.next();
                eg.idCounter = Math.max(eg.id, eg.idCounter)+1;
            }
            
        }
        catch(IOException ex) {
            ex.printStackTrace();
        }
        catch(ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return gr;
    }
    
    public void loadFromGD0(String filename) throws IOException {
        if(filename.length()==0) return;
        binLoad(new FileInputStream(new File(filename)));
         String vars_fname = filename.substring( 0,filename.lastIndexOf(".gd0"));
         try{
        loadVertexVars(new FileInputStream(new File(vars_fname+".vrs")));        
         }catch(FileNotFoundException e)
         {}
    }   
    
    private void loadTxt(File file) throws IOException {
        if (file == null) return;
        
        Reader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StreamTokenizer st = new StreamTokenizer(r);
        st.commentChar('#');
        
        vertices = new Vector();
        edges = new Vector();
        
        while(st.nextToken() != StreamTokenizer.TT_EOF) {
            Vertex nd = new Vertex();
            
            nd.setId((int)st.nval);
            vertices.add(nd);
            nd.setX(250 + (float)Math.random()*30);//m_Vertices.size()*40;
            nd.setY(250 + (float)Math.random()*30);//m_Vertices.size()*40;
            
            st.nextToken();
            
            int edgCount=(int)st.nval;
            nd.edges = new int[edgCount];
            
            for(int i=0;i<edgCount;i++) {
                st.nextToken();
                nd.edges[i]=edges.size();
                edges.add( new Edge(nd.getId(), (int)st.nval) );
            }
        }
        
        //outputGraph(System.out);
    }
    
    public void outputGraph(OutputStream outs) {
        if (outs == null || vertices==null) return;
        
        PrintStream pstr = new PrintStream(outs);
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            pstr.println(""+nd.getId());
            if (nd.edges!=null)
                for(int k=0; k<nd.edges.length; k++) {
                    Iterator it2 = vertices.iterator();
                    Vertex nd2=null;
                    
                    int count = findEdge( nd.edges[k] ).to;
                    nd2 = findVertex(count);
                    pstr.println("    " + nd2.getId());
                }
        }
    }
    
    private void binLoad(InputStream ins) throws IOException {
        if (ins == null) return;
                
        DataInputStream r = new DataInputStream(ins);
        
        vertices = new Vector();
        edges = new Vector();
        
        int in=0;
        boolean done=false;
        while(!done) {
            try{
                in=r.readInt();
            } catch ( EOFException e)
            { done=true; continue; }
            Vertex nd = new Vertex();
            
            nd.setId(in);
            vertices.add(nd);
            nd.setX(250 + (float)Math.random()*30);//m_Vertices.size()*40;
            nd.setY(250 + (float)Math.random()*30);//m_Vertices.size()*40;
            
            try{
                in=r.readInt();
            } catch ( EOFException e)
            { done=true; continue;}
            
            if (in == 0) continue;
            int edgCount=in;
            nd.edges = new int[edgCount];
            
            for(int i=0;i<edgCount;i++) {
                try{
                    in=r.readInt();
                } catch ( EOFException e)
                { done=true; }
                Edge eg;
                edges.add(eg = new Edge(nd.getId(), in) );
                nd.edges[i]=eg.getId();
            }
        }
        //repairAllVertexIds();
        //outputGraph(System.out);
    }
    
    private void binOutputGraph(OutputStream out_stream) throws IOException {
        if (out_stream == null || vertices==null) return;
        DataOutputStream outs = new DataOutputStream(out_stream);
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            outs.writeInt(nd.getId());
            if (nd.edges!=null)
                outs.writeInt(nd.edges.length);
            else {
                outs.writeInt(0);
                continue;
            }
            for(int k=0; k<nd.edges.length; k++) {
                Iterator it2 = vertices.iterator();
                Vertex nd2=null;
                
                int count = findEdge( nd.edges[k] ).to;
                nd2 = findVertex(count);
                // System.out.println("    " + nd2.id);
                outs.writeInt(nd2.getId());
            }
        }
    }
    
    
    public Vertex findVertex(int n) {
        Iterator it = vertices.iterator();
        Vertex vert=null;
        //while( n-- >= 0 && it.hasNext())
        //    vert=(Vertex)it.next();
        while(it.hasNext()) {
            vert=(Vertex)it.next();
            if ( vert.getId() == n) return vert;
        }
        return null;
    }
    
    public int findVertexInd(int n) {
        Iterator it = vertices.iterator();
        Vertex vert=null;
        int ind = 0;
        while(it.hasNext()) {
            vert=(Vertex)it.next();
            if ( vert.getId() == n) return ind;
            ind++;
        }
        return 0;
    }
    
    public Vertex findVertexAtInd(int n) {
        Iterator it = vertices.iterator();
        Vertex vert=null;
        while(it.hasNext()) {
            vert=(Vertex)it.next();
            if ( n == 0) return vert;
            n--;
        }
        return null;
    }
    
    public Edge findEdge(int n) {
        Iterator it = edges.iterator();
        Edge edg=null;
        
        //while( n-- >= 0 && it.hasNext())
        //    edg=(Edge)it.next();
        
        while(it.hasNext()) {
            edg=(Edge)it.next();
            if ( edg.getId() == n) return edg;
        }
        
        return edg;
    }
    
    public void randomizePositions() {
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            nd.setX(250 + (float)Math.random()*30);//m_Vertices.size()*40;
            nd.setY(250 + (float)Math.random()*30);//m_Vertices.size()*40;
        }
    }
    
    synchronized public void relaxVerticePositions() {
        Iterator it = vertices.iterator();
        while (it.hasNext()) {
            Vertex nd = (Vertex)it.next();
            if ( nd.edges == null) continue;
            for (int e=0; e<nd.edges.length; e++) {
                
                Iterator it2 = vertices.iterator();
                Vertex nd2=null;
                int count = findEdge(nd.edges[e]).to;
                do{
                    nd2=(Vertex)it2.next();
                }while( count-- != 0 && it2.hasNext());
                
                float to_x = nd.getX()-nd2.getX();
                float to_y = nd.getY()-nd2.getY();
                
                double dist = Math.sqrt(to_x*to_x+to_y*to_y);
                //System.out.println(""+dist);
                if ( dist > MAX_LENGTH+5 ) {
                    to_x*=-1; to_y*=-1;
                    float norm = (float)Math.sqrt(to_x*to_x+to_y*to_y);
                    if (norm == 0) continue;
                    nd.setX(nd.getX() + (to_x/norm));
                    nd.setY(nd.getY() + (to_y/norm));
                    nd.setX(Math.max(nd.getX(),0f));
                    nd.setY(Math.max(nd.getY(),0f));
                    nd.setX(Math.min(nd.getX(),2000f));
                    nd.setY(Math.min(nd.getY(),2000f));
                }
                else if ( dist < MAX_LENGTH-5 ) {
                    float norm = (float)Math.sqrt(to_x*to_x+to_y*to_y);
                    if (norm == 0) continue;
                    nd.setX(nd.getX() + (to_x/norm));
                    nd.setY(nd.getY() + (to_y/norm));
                    nd.setX(Math.max(nd.getX(),0f));
                    nd.setY(Math.max(nd.getY(),0f));
                    nd.setX(Math.min(nd.getX(),2000f));
                    nd.setY(Math.min(nd.getY(),2000f));
                }
            }
        }
    }
    
    public int[][] getMatrixRepresentation() {
        int matRep[][] = new int[vertices.size()][vertices.size()];
        int ind1=0,ind2=0;
        Vertex vert,vert2;
        Iterator it = vertices.iterator();
        while(it.hasNext()) {
            vert = (Vertex)it.next();
            
            if(vert.edges!=null)
                for (int i=0; i<vert.edges.length;i++) {
                    int v = findEdge(vert.edges[i]).to;
                    Vertex vto = findVertex(v);
                    int in = vert.getId();
                    matRep[findVertexInd(in)][findVertexInd(v)]=1;
                }
            
        }
        return matRep;
    }
    
    public void applyNewMatrixRepresentation(int newMatRep[][]) {
        int ind1=0,ind2=0;
        Vertex vert,vert2;
        Iterator it = vertices.iterator();
        edges.clear();
        while(it.hasNext()) {
            vert = (Vertex)it.next();
            ind1 = findVertexInd(vert.getId());
            vert.edges=null;
            for (int i=0; i<vertices.size();i++) {
                if (newMatRep[ind1][i]==1) {
                    int id = addEdge(
                    new Edge(vert.getId(), findVertexAtInd(i).getId())
                    );
                    vert.addEdge(id);
                }
            }
            
        }
    }
    
    public void repairAllVertexIds()
    {
        if (edges==null) return;
        Iterator it = vertices.iterator();
        Vertex.nextFreeId=0;
        int id_num=0;
        while(it.hasNext())
        {
            Vertex curr = (Vertex)it.next();
            if(curr.getId()==id_num) 
            {
                id_num++;
                continue;
            }            
            Iterator eg_it = edges.iterator();
            while(eg_it.hasNext())
            {
                Edge eg = (Edge)eg_it.next();
                if(eg.from == curr.getId())
                    eg.from = id_num;
                if(eg.to == curr.getId())
                    eg.to = id_num;
            }
            curr.setId(id_num);
            id_num++;
        }
        Vertex.nextFreeId=id_num;
    }
    
    public java.util.List[] getAdjacencyListRepresentation() {
        java.util.List listRep[] = new java.util.List[vertices.size()];
        
        int ind1=0,ind2=0;
        Vertex vert,vert2;
        Iterator it = vertices.iterator();
        while(it.hasNext()) {
            vert = (Vertex)it.next();
            
            if(vert.edges!=null)
                for (int i=0; i<vert.edges.length;i++) {
                    int v = findEdge(vert.edges[i]).to;
                    Vertex vto = findVertex(v);
                    int in = vert.getId();
                    if (listRep[findVertexInd(in)]==null)
                        listRep[findVertexInd(in)] = new java.util.LinkedList();
                    listRep[findVertexInd(in)].add(vto);
                }
            
        }
        return listRep;
    }
    
    public void applyNewListRepresentation(java.util.List newRep[] ) {
        int ind1=0,ind2=0;
        Vertex vert,vert2;
        vertices.clear();
        edges.clear();
        for(int i=0; i< newRep.length; i++) {
            vert = findVertexInAdjTable(newRep,i);
            vert.edges = null;
            vertices.add(vert);
            Iterator it = newRep[i].iterator();
            while( it.hasNext() ) {
                vert2 = (Vertex)it.next();                
                int id = addEdge(
                    new Edge(vert.getId(), vert2.getId())
                );
                vert.addEdge(id);
            }
            
        }
    }
    
    static public Vertex findVertexInAdjTable(java.util.List adjTab[], int id){
        for (int n = 0; n < adjTab.length; n++) {
            Iterator it = adjTab[n].iterator();
            while(it.hasNext()){
                Vertex v = (Vertex)it.next();
                if(v.getId() == id) return v;
            }
        }
        return null;
    }
    
    public void zeroVertexValues() {
        Iterator it = vertices.iterator();
        while(it.hasNext()) {
            Vertex v = (Vertex)it.next();
            v.setValue(0);
        }
    }
    
    public String[] getVertexVars()
    {
        String str[] = new String[vertices.size()];
        Iterator it = vertices.iterator();
        int cnt=0;
        while(it.hasNext())
        {            
            Vertex v = (Vertex)it.next();
            str[cnt++]=v.getVarsAsString();
        }
        return str;
    }
    
    public void setVertexVars(String vars[])
    {        
        Iterator it = vertices.iterator();
        int cnt=0;
        while(it.hasNext())
        {            
            Vertex v = (Vertex)it.next();
            v.setVertexHashVars(vars[cnt++]);
        }        
    }
    
    static int[][][] textLoad(File file) throws IOException {
        if (file == null) return null;
        
        Reader r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StreamTokenizer st = new StreamTokenizer(r);
        st.commentChar('#');
        
        st.nextToken();
        int lines=(int)st.nval;        
        int ret[][][] = new int[lines][2][];
        int cur=0;
        while(cur < lines && st.nextToken() != StreamTokenizer.TT_EOF) {            
            int ints=(int)st.nval;                      
            ret[cur][0]=new int[ints];
            for(int i=0;i<ints;i++)
            {
                st.nextToken();            
                ret[cur][0][i]=(int)st.nval;
            }
            ret[cur][1]=new int[1];
            st.nextToken();            
            ret[cur][1][0]=(int)st.nval;
            cur++;
        }        
        return ret;
    }
    
       static void textSave(File file,int tab[][][]) throws IOException {
        if (file == null) return;        
        PrintStream pstr = new PrintStream(new FileOutputStream(file));
        pstr.println(""+tab.length);
        for(int i=0;i<tab.length;i++)
        {
            pstr.print(""+tab[i][0].length+" ");
            for(int n=0;n<tab[i][0].length;n++)
            {
                pstr.print(""+tab[i][0][n]+" ");                      
            }
            pstr.println(""+tab[i][1][0]);                        
        }                
    }
    
    static public void main(String args[])
    {
        int tab[][][] = new int[][][]{
            { {1,2,3},{1}},
            { {1,2,3,4},{0}},
            { {1,2,3,4,5},{0}},            
        };
        try{
        textSave(new File("test.txt"), tab);
        tab = textLoad(new File("test.txt"));
        }catch(IOException e){e.printStackTrace();}
    }
    
}