/*
 * MyGraph.java
 *
 * Created on 7 listopad 2003, 08:51
 */
package AGR;

import javax.swing.text.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.*;
import javax.swing.*;
import java.util.*;
import java.awt.event.*;

import AGR.plugins.*;

/**
 *
 * @author  x
 */
public class MainWindow extends JFrame implements ActionListener, MouseListener, ChangeListener {
    
    public Graph m_graph;
    public GraphView m_graphView;
    JButton m_loadBtn;
    JButton m_saveBtn;
    JButton m_relaxBtn;
    JButton m_newGraph;
    
    JButton m_stepRewind = new JButton("Init");
    JButton m_stepToEnd  = new JButton("End");
    JButton m_stepForward  = new JButton(">>");
    JButton m_stepBackward = new JButton("<<");
    JButton m_stepPause  = new JButton("||");
    boolean m_wasPausePressed = false;
    JButton m_stepPlay  = new JButton(">");
    
    Vector m_plugins = new Vector();
    JList m_pluginList;
    
    static JTextPane m_tp;
    JCheckBox m_diGraph;
    
    Vertex m_lastPressedVertex;
    
    JRadioButton m_ownFormatRadioBtn;
    JRadioButton m_objFormatRadioBtn;
    ButtonGroup m_radioGrp;
    
    JRadioButton m_addVertexRadioBtn;
    JRadioButton m_addEdgeRadioBtn;
    JRadioButton m_moveNodeBtn;
    JRadioButton m_removeNodeBtn;
    JRadioButton m_removeEdgeBtn;
    JRadioButton m_changeEdgeValueBtn;
    JRadioButton m_changeNodeValueBtn;
    ButtonGroup m_operRadioGrp;
    JSlider m_slider;
    
    /** Creates a new instance of MyGraph */
    public MainWindow() {
        setTitle("Graph viz 1.0");
        lookForPlugins();
        
        setBounds(100,100, 640,480);
        if (!AppletWindow.m_appletMode)
            setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        getContentPane().setLayout(new BorderLayout());
        
        Box mainScreenBox = Box.createVerticalBox();
        Box upperBarBox = Box.createHorizontalBox();
        Box leftBarBox = Box.createVerticalBox();
        
        // make instances of class that will visualize graphs
        m_graphView = new GraphView();
        m_graph = new Graph();
        m_graphView.setGraph(m_graph);
        
        // initialize mainscreen panel - graph visualizator and console
        m_graphView.setPreferredSize(new Dimension(640,300));
        m_tp = new JTextPane();
        m_tp.setFont(Font.getFont("fixedsys"));
        JScrollPane sp = new JScrollPane(m_tp);
        m_tp.setEditable(false);
        sp.setPreferredSize(new Dimension(640,120));
        m_tp.setPreferredSize(new Dimension(640,120));
        mainScreenBox.add(new JScrollPane(m_graphView));
        JSplitPane splitPane;
        getContentPane().add(
        splitPane=new JSplitPane(
        JSplitPane.VERTICAL_SPLIT,
        new JScrollPane(m_graphView),
        sp),
        BorderLayout.CENTER
        );
        
        ///left panel init
        if(AppletWindow.ms_applet==null) 
        {
            upperBarBox.add(m_loadBtn = new JButton("load"));
            upperBarBox.add(m_saveBtn = new JButton("save"));
        }
        upperBarBox.add(m_newGraph = new JButton("new graph"));
        m_radioGrp=new ButtonGroup();
        
        if(AppletWindow.m_appletMode==false) {
            m_radioGrp.add(m_ownFormatRadioBtn = new JRadioButton("gd0 format"));
            m_radioGrp.add(m_objFormatRadioBtn = new JRadioButton("obj format"));
            
            leftBarBox.add(m_ownFormatRadioBtn);
            leftBarBox.add(m_objFormatRadioBtn);
        }
        leftBarBox.add(m_relaxBtn = new JButton("relax"));
        leftBarBox.add(m_slider = new JSlider(0,500));
        m_slider.setPreferredSize(new Dimension(35, 20));
        m_slider.addChangeListener(this);
        leftBarBox.add(m_diGraph = new JCheckBox("digraph",true));
        
        m_operRadioGrp = new ButtonGroup();
        m_operRadioGrp.add(m_addVertexRadioBtn = new JRadioButton("add node"));
        m_operRadioGrp.add(m_addEdgeRadioBtn = new JRadioButton("add edge"));
        m_operRadioGrp.add(m_moveNodeBtn = new JRadioButton("move node"));
        m_operRadioGrp.add(m_removeEdgeBtn = new JRadioButton("remove edge"));
        m_operRadioGrp.add(m_removeNodeBtn = new JRadioButton("remove node"));
        m_operRadioGrp.add(m_changeEdgeValueBtn = new JRadioButton("<HTML>change edge<br> value"));
        m_operRadioGrp.add(m_changeNodeValueBtn = new JRadioButton("<HTML>change node<br> variables"));
        
        m_operRadioGrp.setSelected(m_addVertexRadioBtn.getModel(), true);
        
        leftBarBox.add(m_addVertexRadioBtn);
        leftBarBox.add(m_addEdgeRadioBtn);
        leftBarBox.add(m_moveNodeBtn);
        leftBarBox.add(m_removeNodeBtn);
        leftBarBox.add(m_removeEdgeBtn);
        leftBarBox.add(m_changeEdgeValueBtn);
        leftBarBox.add(m_changeNodeValueBtn);
        
        JScrollPane scrollp = new JScrollPane();
        scrollp.setPreferredSize(new Dimension(20,100));
        scrollp.getViewport().setView(m_pluginList);
        leftBarBox.add(new JLabel("loaded plugins:"));
        leftBarBox.add(scrollp);
        
        //initilize upper panel (bar)
        upperBarBox.add(m_stepRewind);
        //        upperBarBox.add(m_stepToEnd);
        upperBarBox.add(m_stepBackward);
        upperBarBox.add(m_stepPause);
        upperBarBox.add(m_stepPlay);
        upperBarBox.add(m_stepForward);
        getContentPane().add(upperBarBox,BorderLayout.NORTH);
        
        ////////////
        
        getContentPane().add(leftBarBox,BorderLayout.WEST);
        
        m_newGraph.addActionListener(this);

                
        if(AppletWindow.m_appletMode==false) 
        {
            m_radioGrp.setSelected( m_ownFormatRadioBtn.getModel(), true);
            m_loadBtn.addActionListener(this);
            m_saveBtn.addActionListener(this);
        }
        m_relaxBtn.addActionListener(this);
        
        m_stepRewind.addActionListener(this);
        m_stepToEnd.addActionListener(this);
        m_stepForward.addActionListener(this);
        m_stepBackward.addActionListener(this);
        m_stepPause.addActionListener(this);
        m_stepPlay.addActionListener(this);
        
        pack();
        m_graphView.setPreferredSize(new Dimension(2000,2000));
        
        splitPane.setDividerLocation(0.8);
        splitPane.setOneTouchExpandable(true);
        
        m_graphView.addMouseListener(this);
        printToConsole("Graph viz 1.0 by Marcin Jdrzejewski\n");
        printToConsole("email: s1525@pjwstk.edu.pl\n");
        printToConsole("  www: http://www.pjwstk.edu.pl/~s1525\n");
    }
    
    protected static String ask4file(final String ext) throws IOException {
        JFileChooser fc = new JFileChooser();
        
        String uname;
        uname = "";
        if (uname==null) uname="";
        fc.setSelectedFile(new java.io.File(uname));
        fc.setCurrentDirectory(new File("."));
        fc.setFileFilter(new FileFilter() {
            public String getDescription() {
                return "Graph files";
            }
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(ext);
            }
        });
        
        int returnVal = fc.showDialog(null, "Ok");
        
        File file = null;
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            file = fc.getSelectedFile();
            if (!file.getName().endsWith(ext)) {
                file = new File(file.getAbsolutePath() + ext);
            }
            
        } else {
            System.out.println("Open command cancelled by user.");
        }
        
        if (file == null)
            return "";
        else
            return file.getCanonicalPath();
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        new MainWindow().show();
    }
    
    public void actionPerformed(ActionEvent e) {
        
        ////////////////////////////////////
        // Load file
        if (e.getSource() == m_loadBtn) {
            try {
                if(m_ownFormatRadioBtn.isSelected()) {
                    String fname = ask4file(".gd0");
                    if (fname.length()>0) m_graph = new Graph();
                    m_graph.loadFromGD0(fname);
                    //m_graph.outputGraph(System.out);
                }
                if(m_objFormatRadioBtn.isSelected()) {
                    String fname = ask4file(".obj");
                    if (fname.length()>0) m_graph = new Graph();
                    m_graph = Graph.loadObj(fname);
                }
            } catch(IOException err) {
                err.printStackTrace();
            }
            m_graphView.setGraph(m_graph);
            m_graphView.repaint();
        }
        
        ////////////////////////////////////
        // New graph
        if (e.getSource() == m_newGraph) {
            Vertex.nextFreeId = 0;
            m_graph = new Graph();
            m_graphView.setGraph(m_graph);
            m_graphView.repaint();
        }
        
        if (e.getSource() == m_stepPause){
            synchronized (m_stepPlay){
                m_wasPausePressed = true;
            }
            m_graphView.repaint();
        }
        
        if (e.getSource() == m_stepForward){
            if ( m_graph == null || m_pluginList.getSelectedIndex()==-1) return;
            synchronized (m_stepPlay){
                m_wasPausePressed = true;
            }
            Plugin plugin = (Plugin)m_plugins.elementAt(m_pluginList.getSelectedIndex());
            if (!plugin.canDoForward()) return;
            if (plugin.isFinished())
                plugin.start(m_graph, m_graphView.m_lastVertexClicked);
            plugin.incStep();
            m_graphView.repaint();
        }
        
        if (e.getSource() == m_stepBackward){
            if ( m_graph == null || m_pluginList.getSelectedIndex()==-1) return;
            synchronized (m_stepPlay){
                m_wasPausePressed = true;
            }
            Plugin plugin = (Plugin)m_plugins.elementAt(m_pluginList.getSelectedIndex());
            if (!plugin.canDoBackward()) return;
            if (plugin.isFinished())
                plugin.start(m_graph, m_graphView.m_lastVertexClicked);
            plugin.decStep();
            m_graphView.repaint();
        }
        
        if (e.getSource() == m_stepPlay) {
            if ( m_graph != null && m_pluginList.getSelectedIndex()!=-1) {
                Plugin plugin = (Plugin)m_plugins.elementAt(m_pluginList.getSelectedIndex());
                if (plugin.isFinished())
                    plugin.start(m_graph, m_graphView.m_lastVertexClicked);
                m_graphView.repaint();
                if (!plugin.isFinished())
                    new Thread(){
                        public void run(){
                            synchronized (m_stepPlay) { m_wasPausePressed = false; }
                            setName("Play thread");
                            Plugin plugin = (Plugin)m_plugins.elementAt(m_pluginList.getSelectedIndex());
                            while(true){
                                synchronized (m_stepPlay){
                                    if (m_wasPausePressed) {
                                        m_wasPausePressed=false;
                                        return;
                                    }
                                }
                                if (plugin.isFinished()) 
                                {
                                    m_graphView.repaint();
                                    return;
                                }
                                plugin.incStep();
                                m_graphView.repaint();
                                try {
                                    Thread.sleep(1000);
                                } catch(InterruptedException e)
                                { e.printStackTrace(); }
                            }
                        }
                    }.start();
            }
        }
        
        if (e.getSource() == m_stepRewind) {
            if ( m_graph != null && m_pluginList.getSelectedIndex()!=-1) {
                Plugin plugin = (Plugin)m_plugins.elementAt(m_pluginList.getSelectedIndex());
                plugin.setStartStep();
                m_graphView.repaint();
            }
        }
        
        if (e.getSource() == m_saveBtn) {
            try {
                if(m_ownFormatRadioBtn.isSelected())
                    m_graph.saveAsGD0(ask4file(".gd0"));
                if(m_objFormatRadioBtn.isSelected())
                    m_graph.save(ask4file(".obj"));
            } catch(IOException err) {
                err.printStackTrace();
            }
            m_graphView.setGraph(m_graph);
        }
        
        if (e.getSource() == m_relaxBtn) {
            synchronized(m_graphView) {
                m_graphView.m_doRelax=!m_graphView.m_doRelax;
                //if (m_graphView.m_doRelax)
                //    m_graph.randomizePositions();
            }
        }
        
    }
    
    public static void printToConsole(String str) {
        Document doc = m_tp.getDocument();
        try {
            doc.insertString(doc.getEndPosition().getOffset()-1, str, null);
        } catch ( BadLocationException e)
        { e.printStackTrace(); }
        m_tp.getCaret().setDot(doc.getEndPosition().getOffset()-1);
    }
    
    public void mouseClicked(MouseEvent e) {
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
        ////////////////////////////////
        // only for left button clicks
        if (e.getButton() != MouseEvent.BUTTON1) return;
        
        ////////////////////////////////
        // if in add vertex mode
        if ( m_operRadioGrp.getSelection() == m_addVertexRadioBtn.getModel()) {
            Vertex vert = new Vertex();
            vert.setX(e.getPoint().x);
            vert.setY(e.getPoint().y);
            vert.setVertexHashVars("k=0");
            if (m_graph!=null){
                m_graph.addVertex(vert);
            }
        }
        
        ////////////////////////////////
        // if in remove vertex mode
        if ( m_operRadioGrp.getSelection() == m_removeNodeBtn.getModel()) {
            if (m_graph!=null && m_graphView.m_lastVertexOver!=null){
                synchronized(m_graphView) {
                    m_graph.removeVertex(m_graphView.m_lastVertexOver);
                }
            }
        }
        
        ////////////////////////////////
        // if in remove edge mode
        if ( m_operRadioGrp.getSelection() == m_removeEdgeBtn.getModel()) {
            if (m_graph!=null && m_graphView.m_lastEdgeOver!=null){
                synchronized(m_graphView) {
                    m_graph.removeEdge(m_graphView.m_lastEdgeOver);
                }
            }
        }
        
        ////////////////////////////////
        // if in change edge value mode
        if ( m_operRadioGrp.getSelection() == m_changeEdgeValueBtn.getModel()) {
            if (m_graph!=null && m_graphView.m_lastEdgeOver!=null){
                synchronized(m_graphView) {
                    String newValue = JOptionPane.showInputDialog(this.getContentPane(),"new edge value");
                    try{
                        m_graphView.m_lastEdgeOver.value=Integer.parseInt(newValue);
                    }catch(NumberFormatException er) {
                        printToConsole("\nWrong number entered");
                    }
                }
            }
        }
        
        ////////////////////////////////
        // if in change node value mode
        if ( m_operRadioGrp.getSelection() == m_changeNodeValueBtn.getModel()) {
            if (m_graph!=null && m_graphView.m_lastVertexOver !=null){
                synchronized(m_graphView) {
                    String newValue = "";
                    do{
                        newValue = JOptionPane.showInputDialog(this.getContentPane(),"Node value",
                        m_graphView.m_lastVertexOver.getVarsAsString());
                        if (newValue==null) break;
                        if (hasVertexCorrectVars(newValue)) {
                            m_graphView.m_lastVertexOver.setVertexHashVars(newValue);
                            break;
                        }
                        JOptionPane.showMessageDialog(null,"Incorrect syntax : should be 'var1=1;var2=2'");
                    }while(true);
                }
            }
        }
        
        ////////////////////////////////
        // if in add edge mode
        if ( m_operRadioGrp.getSelection() == m_addEdgeRadioBtn.getModel()) {
            if (m_graph!=null){
                if ( m_lastPressedVertex == null )
                    m_lastPressedVertex = m_graphView.m_lastVertexOver;
                else {
                    if ( m_graphView.m_lastVertexOver == null ) return;
                    Edge edg = new Edge(m_lastPressedVertex.getId(),
                    m_graphView.m_lastVertexOver.getId());
                    int addedEdge = m_graph.addEdge(edg);
                    m_lastPressedVertex.addEdge(addedEdge);
                    
                    if (!m_diGraph.isSelected()) //i wdrug stron jeli nie digraf
                    {
                        edg = new Edge(m_graphView.m_lastVertexOver.getId(),
                        m_lastPressedVertex.getId());
                        addedEdge = m_graph.addEdge(edg);
                        m_graphView.m_lastVertexOver.addEdge(addedEdge);
                    }
                    m_lastPressedVertex = null;
                }
            }
        }
        
        m_graphView.repaint();
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == m_slider) {
            if(m_graph!=null) {
                synchronized(m_graphView) {
                    m_graph.MAX_LENGTH=m_slider.getValue();
                }
            }
        }
    }
    
    public void lookForPlugins() {
        File pluginDir;
        String pnames[]=null;
        
        if (!AppletWindow.m_appletMode) {            
            pluginDir = new File("./plugins");
            pnames = pluginDir.list(new FilenameFilter(){
                public boolean accept(File dir,String name){
                    return name.indexOf(".class")!=-1 ? true : false;
                }
            });
            }
        else
        {
            //String path = AppletWindow.ms_applet.getCodeBase()+ "/plugins";
            //pluginDir = new File(path);
            //System.out.println(path);
            pnames = new String[]{"BFS.class","DFS.class","ShowMatrix.class","TransitiveClosure.class","Transpose.class"};
        }
        
        for (int n=0; n<pnames.length; n++) {
            Class newPlugin=null;
            try{
                pnames[n]="AGR.plugins."+pnames[n].replaceAll("\\.class","");
                newPlugin = Class.forName(pnames[n]);
            }catch(ClassNotFoundException e) {
                e.printStackTrace();
            }
            //catch(IOException e)
            //{e.printStackTrace();}
            
            if (newPlugin!=null) {
                Object obj=null;
                try{
                    obj = newPlugin.newInstance();
                }
                catch(InstantiationException e){
                    //e.printStackTrace();
                }
                catch(IllegalAccessException e){
                    e.printStackTrace();
                }
                if (obj != null && obj instanceof Plugin) {
                    Plugin pin = (Plugin)obj;
                    m_plugins.add(pin);
                    //                    printToConsole(""+pin.getName());
                }
            }
        }
        //m_plugins
        m_pluginList = new JList(m_plugins);
    }
    
    protected boolean hasVertexCorrectVars(String nodeVars) {
        String t1,t2;
        StringTokenizer stok = new StringTokenizer(nodeVars,";");
        while(stok.hasMoreTokens()) {
            t1=stok.nextToken();
            StringTokenizer stok2 = new StringTokenizer(t1,"=");
            if (stok2.hasMoreElements() == false) return false;
            t1 = stok2.nextToken();
            if (stok2.hasMoreElements() == false) return false;
            t2 = stok2.nextToken();
            if (stok2.hasMoreElements()) return false;
        }
        return true;
    }
    
    
}