//
// Simple Lighting Model
// Copyright (c) Microsoft Corporation. All rights reserved.
//
// Note: This effect file works with EffectEdit.
//


float3 listenerPos;
int iteration;

// texture
texture Triangle1Data;
texture Triangle2Data;
texture Triangle3Data;
texture TriangleNormalData;
texture LeafData;

texture Rt1Data;
texture Rt2Data;
texture Rt3Data;
texture Rt4Data;

// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 Projection : PROJECTION;

struct VS_OUTPUT
{
    float4 Pos  : POSITION;    
    float2 Tex : TEXCOORD0;    
};

VS_OUTPUT VS(
    float3 Pos  : POSITION, 
    float3 Norm : NORMAL, 
    float2 Tex  : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;

    
    float4x4 WorldView = mul(World, View);        
    float3 P = mul(Pos, WorldView);    
    Out.Pos  = mul(float4(P, 1), Projection);              // position (projected)
    //Out.Diff = float4(1,0,0,0); // diffuse + ambient
    Out.Tex = Tex;
    return Out;
}

sampler SamplerTri1 = sampler_state
{
    Texture   = (Triangle1Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler SamplerTri2 = sampler_state
{
    Texture   = (Triangle2Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler SamplerTri3 = sampler_state
{
    Texture   = (Triangle3Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler SamplerTriNormals = sampler_state
{
    Texture   = (TriangleNormalData);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler SamplerLeafData = sampler_state
{
    Texture   = (LeafData);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};

sampler StateData1 = sampler_state
{
    Texture   = (Rt1Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler StateData2 = sampler_state
{
    Texture   = (Rt2Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler StateData3 = sampler_state
{
    Texture   = (Rt3Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};
sampler StateData4 = sampler_state
{
    Texture   = (Rt4Data);
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
};

const float EPSILON = 0.00001f;

float4 intersect(
    float3 orig,
           float3 dir,
    float3 v0,
    float3 v1,
    float3 v2)
{
    dir=normalize(dir);
    orig = listenerPos;
    float t,u,v;
    bool intersection = true;
    
    float3 edge1, edge2, tvec, pvec, qvec;
    float det;
    float inv_det;

    edge1 = v1 - v0;
    edge2 = v2 - v0;
    
    pvec = cross(dir, edge2);
    det = dot(edge1, pvec);
    if ( det > -EPSILON && det < EPSILON)
        intersection = false;

    inv_det = 1.0 / det;

    tvec = orig - v0;    

    u = dot ( tvec, pvec) * inv_det;
    if ( u < 0.0 || u > 1.0)
        intersection = false;

    qvec = cross( tvec, edge1);
    v = dot(dir, qvec) * inv_det;

    if ( v < 0.0 || u + v > 1.0 )
        intersection = false;
    
    t = dot(edge2, qvec) * inv_det;

    float4 ret_val = float4(0.0, 0.0, 0.0, 0.0);

    if ( intersection ) ret_val = float4(t,u,v,1.0);

    return ret_val;
}

const float TextureDim;// = 128.0f;
const float off;// = 1.0f/128.0f;
const float bias;// = 0.5f/128.0f;

float2 getOff(int pos)
{
    float2 res;
    res.x = floor(pos / TextureDim); 
    res.y = pos - res.x*TextureDim;
    res =  res * off + bias;
    return res.yx;
}

struct PS_OUTPUT
{
    float4 state : COLOR0;            
    float4 ray_origin : COLOR1;   
    float4 ray_direction : COLOR2;        
//    float4 rt4 : COLOR3;   
};

PS_OUTPUT PS(    
    float2 Tex : TEXCOORD0
   )
{   
    //data1.x <- actual leaf number
    //data1.y <- actual triangle/portal examined from this leaf
            //data2.xyz <- ray origin
            //data3.xyz <- ray direction vector

    float4 data1 = tex2D(StateData1 , Tex);
    float4 data2 = tex2D(StateData2 , Tex);
    float4 data3 = tex2D(StateData3 , Tex);
    float4 data4 = tex2D(StateData4 , Tex);        
    
    //pobierz indeks w tablicy leafow zeby pobrac
    // pierwszy indeks trojkata dla tego leafa
    float2 leafNumberUV = getOff(data1.x+data1.y);
    float4 triIndex = tex2D(SamplerLeafData, leafNumberUV);

           //if -1 value then it means we reached beyond last triangle for these leaf,
           // these should never happend actually
           clip(triIndex);

    //vertexy trojkata
    float2 triPos = getOff(triIndex.x);
    float4 v0 = tex2D(SamplerTri1 ,triPos );
    float4 v1 = tex2D(SamplerTri2 ,triPos );
    float4 v2 = tex2D(SamplerTri3 ,triPos );
    float4 triNormal = tex2D(SamplerTriNormals ,triPos );

            //v0.w <- equals -1 if its a triangle
            //v1.w <- equals leaf number that should be set for next iteration,
            //              if its triangle then this ray will stay in the same leaf
            //              if it was portal then this value will be leaf number of neighbouring leaf
            //                where ray should now travel
    
    float4 res1 =  intersect(
                                                       data2.xyz, // ray origin
                                                       data3.xyz,                                                        
                                                        v0,v1,v2);//triangle verticies
    
            
            

    PS_OUTPUT psout=(PS_OUTPUT )0;
        psout.state=res1;
        psout.ray_origin=res1;
        psout.ray_direction=res1;
//        psout.rt4=float4(1,0,1,0);

    return psout;
    /*
    return float4(0.1f,//triOffset.z,  //beam number
                  res1.w, //intersection result
                    triOffset.z, 0);
                    */
}

technique TVertexAndPixelShader
{
    pass P0
    {
        // shaders
        VertexShader = compile vs_2_0 VS();
        PixelShader  = compile ps_2_0 PS();
    }  
}
